#!/bin/bash
# dwave/DYNAMiCS
DYNSYN_PROC_TITLE=DYNSYN3cfh89aZidKSZk93klaABFF

# ##################
# FUNCTION: dynsyn_play(String package_path, String music_file)
# USAGE: dynsyn_play "/Users/Void/Desktop/MyProgram.pkg/" "MyMusicFile.mp3"
# EXAMPLE USAGE IN InstallationCheck: dynsyn_play "$1" "MyMusicFile"
#
dynsyn_play() {
	package_path=$1
	music_file=$2
	dynsyn_path="$package_path/Contents/Resources"

	# remove any stale pid file from previous sessions.
	#rm -f /tmp/dynsyn-current-pid
	# set the dynsyn executable setuid so that we are sure
	# that the player is run as the normal user, not the root user,
	# thus keeping any audio user settings such as preffered audio output.
	chmod 0755 "$dynsyn_path/Dynsynmon.pl"
	chmod 4755 "$dynsyn_path/dynsyn"

	# get on with some beats...
	"$dynsyn_path/DynsynMon.pl" "$dynsyn_path/dynsyn" --loop "$dynsyn_path/$music_file"
}

# ##################
# FUNCTION: dynsyn_stop
# NOTE: Deprecated! DynsynMon.pl takes care of this.
dynsyn_stop() {
	# first try to kill dynsyn the safe way:
	if [ -f /tmp/dynsyn-current-pid ]; then
		kill $(cat /tmp/dynsyn-current-pid) >> /dev/null
	# then if it didn't work, try the hard way;
	else
		ps auxww | grep "$DYNSYN_PROC_TITLE" | grep -v grep >> /dev/null \
			&& killall dynsyn >> /dev/null
	fi
}
